// -----------------------------------------------------------------------------------------
//                     T I N   C A N
//------------------------------------------------------------------------------------------
//#include "household_oil/household_oil.inc"
//object { household_oil rotate <0,-30,0> }


#include "tin_can/tin_can_materials.inc"


#macro make_box_torus (_rad1,_rad2,_width,_depth)
        #local _pX = (_width/2)-_rad1;
        #local _pZ = (_depth/2)-_rad1; 
        
        #local _corner = 
        difference {
            torus { _rad1, _rad2 }
            plane { <0,0,-1>, 0 } 
            plane { <-1,0,0>, 0 }
        }
       union {  
           object { _corner rotate <0,0,0>      translate <-_pX,0,-_pZ> }  
           object { _corner rotate <0,0,180>    translate <_pX,0,-_pZ>  }
           object { _corner rotate <180,0,0>    translate  <-_pX,0,_pZ> }  
           object { _corner rotate <180,0,180>  translate <_pX,0,_pZ>   }
           object { cylinder {<-_pX,0,0>,<_pX,0,0>,_rad2} translate <0,0,-_depth/2> }
           object { cylinder {<-_pX,0,0>,<_pX,0,0>,_rad2} translate <0,0,_depth/2> }
           object { cylinder {<0,0,-_pZ>,<0,0,_pZ>,_rad2} translate <-_width/2,0,0> }
           object { cylinder {<0,0,-_pZ>,<0,0,_pZ>,_rad2} translate <_width/2,0,0> }
       }
#end




#macro make_box_fillet (_rad1,_height,_width,_depth)
        #local _pX = (_width/2)-_rad1;
        #local _pZ = (_depth/2)-_rad1; 
        
        #local _corner = cylinder {<0,0,0>,<0,_height,0>,_rad1 }
        union {  
            object { _corner  translate < -_pX, 0, -_pZ> }  
            object { _corner  translate < _pX,  0, -_pZ> }
            object { _corner  translate < -_pX, 0, _pZ>  }  
            object { _corner  translate < _pX,  0, _pZ>  }
            box {<-_pX,0,-_depth/2>,<_pX,_height,_depth/2>}
            box {<-_width/2,0,-_pZ>,<_width/2,_height,_pZ>}
        }
#end




#declare _width = 50; 
#declare _depth = 50;  
#declare _height = 62.5;
#declare _rad1 = 7;
#declare _rad2 = .4 ;

#declare body =
union {
    union {
        object { make_box_torus  (_rad1,_rad2,_width,_depth) scale <1,2,1> translate <0,_rad2/2,0>}
        material {M_metal_steel_old}
    }
    union {
        object { make_box_fillet (_rad1,_height,_width,_depth) scale <1,1,1> translate <0,0,0> }
        #declare _rad2 = 1.1 ;
        object { make_box_torus  (_rad1,_rad2,_width,_depth) scale <1,1.2,1> translate <0,_height,0>}
        material {M_tin_can_label}  
        
    }
}  

#declare lid_A =
union {
    #declare _rad2 = 1 ;
    object { make_box_torus  (_rad1,_rad2,_width,_depth) scale <1,.7,1> translate <0,_rad2,0> material {M_metal_steel_old}}
    object { make_box_fillet (_rad1,_rad2*2,_width,_depth) scale <1,1,1> translate <0,0,0> }
    translate <0,62.5,0>
    material {M_tin_can_label} 
}
       


#declare label =
object {
    box {<-18,0,0>,<18,50,-.1>}
    material { M_tin_can_label_2 }
}
   

#declare _width = 50; 
#declare _depth = 50;  
#declare _height = 4;
#declare _rad1 = 7;
#declare _rad2 = 1;

#declare lid_B =
union {
    object { make_box_fillet ( _rad1,  _height,  _width,  _depth) scale <1,1,1> translate <0,0,0> }  //base
    object { make_box_torus ( _rad1-_rad2,_rad2,_width-_rad2*2,_depth-_rad2*2) scale <1,1,1> translate <0,_height,0>}
    object { make_box_fillet (_rad1-_rad2,_height+_rad2,_width-_rad2*2,_depth-_rad2*2) scale <1,1,1> translate <0,0,0> }
    translate <0,64.5,0>
    material {M_tin_can_label} 
}


#declare _width = 46; 
#declare _depth = 46;  
#declare _height = 6;
#declare _rad1 = 3;



#include "shapes3.inc"

#declare lid_C =  object{  
    Round_Box(<-_width/2,0,-_depth/2>,<_width/2,_height,_depth/2>, _rad1, 0) 
    translate <0,66,0> 
    material {M_tin_can_label}
}






#declare tin_can =
union {

    object { body }
    union {
        object { lid_A } 
        object { lid_B }   
        object { lid_C } 
        translate <0,1,0>
    } 
    object { label translate <0,5,-25> rotate <0,-90,0>}
    object { label translate <0,5,-25> rotate <0,90,0>}
}
